<?php
/**
 * Test completo del proceso de login
 * Simula exactamente Auth::attempt()
 */
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];

try {
    $pdo = new PDO('mysql:host=localhost;port=3306;dbname=opticore;charset=utf8mb4', 'root', 'root', $options);
    echo "✓ DB conectada\n\n";
} catch (Exception $e) {
    die("✗ DB ERROR: " . $e->getMessage() . "\n");
}

$email    = 'josuepazmino@gmail.com';
$password = 'natanael1';

echo "=== PASO 1: Buscar usuario ===\n";
$stmt = $pdo->prepare(
    "SELECT u.*, r.slug as rol_slug, r.nombre as rol_nombre,
            e.nombre as empresa_nombre, e.estado as empresa_estado,
            e.moneda as empresa_moneda,
            s.nombre as sucursal_nombre
     FROM usuarios u
     LEFT JOIN roles r ON u.rol_id = r.id
     LEFT JOIN empresas e ON u.empresa_id = e.id
     LEFT JOIN sucursales s ON u.sucursal_id = s.id
     WHERE u.email = ? AND u.estado = 'activo'
     LIMIT 1"
);
$stmt->execute([$email]);
$user = $stmt->fetch();

if (!$user) {
    echo "✗ Usuario NO encontrado con email='$email' y estado='activo'\n";
    // Buscar sin filtro de estado
    $stmt2 = $pdo->prepare("SELECT id, email, estado FROM usuarios WHERE email = ?");
    $stmt2->execute([$email]);
    $u2 = $stmt2->fetch();
    if ($u2) {
        echo "  → Usuario existe pero estado='{$u2['estado']}'\n";
    } else {
        echo "  → Usuario NO existe en la BD\n";
    }
    die();
}
echo "✓ Usuario encontrado: ID={$user['id']}, email={$user['email']}, estado={$user['estado']}\n\n";

echo "=== PASO 2: Verificar contraseña ===\n";
if (!password_verify($password, $user['password'])) {
    echo "✗ password_verify() FALLÓ\n";
    echo "  Hash en BD: {$user['password']}\n";
    die();
}
echo "✓ Contraseña correcta\n\n";

echo "=== PASO 3: Verificar empresa ===\n";
echo "  es_superadmin: {$user['es_superadmin']}\n";
echo "  empresa_estado: " . ($user['empresa_estado'] ?? 'NULL') . "\n";
if (!$user['es_superadmin'] && $user['empresa_estado'] !== 'activa') {
    echo "✗ Empresa INACTIVA o NULL\n";
    die();
}
echo "✓ Verificación empresa OK\n\n";

echo "=== PASO 4: Verificar columna ultimo_login ===\n";
$cols = $pdo->query("SHOW COLUMNS FROM usuarios LIKE 'ultimo_login'")->fetchAll();
if (empty($cols)) {
    echo "✗ Columna 'ultimo_login' NO EXISTE en tabla usuarios\n";
    echo "  → Esto causaría un error en Auth::attempt() al hacer el UPDATE\n";
} else {
    echo "✓ Columna 'ultimo_login' existe\n";
}

echo "\n=== PASO 5: Verificar tabla audit_logs ===\n";
try {
    $pdo->query("SELECT 1 FROM audit_logs LIMIT 1");
    echo "✓ Tabla 'audit_logs' existe\n";
} catch (Exception $e) {
    echo "✗ Tabla 'audit_logs' NO EXISTE: " . $e->getMessage() . "\n";
    echo "  → Esto causaría un error en AuditLog::log() dentro de Auth::attempt()\n";
}

echo "\n=== PASO 6: Verificar tabla rol_permisos ===\n";
$permisos = $pdo->prepare(
    "SELECT p.nombre FROM rol_permisos rp
     JOIN permisos p ON rp.permiso_id = p.id
     WHERE rp.rol_id = ? AND rp.granted = 1"
);
$permisos->execute([$user['rol_id']]);
$permisosArr = $permisos->fetchAll();
echo "✓ Permisos cargados: " . count($permisosArr) . " permisos para rol_id={$user['rol_id']}\n";

echo "\n=== RESULTADO ===\n";
echo "✓ Auth::attempt() DEBERÍA retornar TRUE\n";
echo "  Si el login sigue fallando, el problema es el CSRF token o la sesión PHP\n";
