<?php
/**
 * OptiCore SaaS - Configuración Principal
 * Ajusta BASE_URL según tu entorno MAMP
 */

// ── Entorno ──────────────────────────────────────────────────
define('APP_ENV',     'development'); // 'production' en producción
define('APP_NAME',    'OptiCore');
define('APP_VERSION', '1.0.0');

// ── URL Base ─────────────────────────────────────────────────
// MAMP Windows: acceso directo via /public
define('BASE_URL', 'http://localhost/opticore/public');

// ── Rutas de directorios ──────────────────────────────────────
define('ROOT_PATH',       dirname(__DIR__));
define('APP_PATH',        ROOT_PATH . '/app');
define('CONFIG_PATH',     ROOT_PATH . '/config');
define('PUBLIC_PATH',     ROOT_PATH . '/public');
define('VIEWS_PATH',      APP_PATH  . '/views');
define('UPLOADS_PATH',    PUBLIC_PATH . '/uploads');
define('STORAGE_PATH',    ROOT_PATH . '/storage');

// ── Sesión ────────────────────────────────────────────────────
define('SESSION_NAME',    'opticore_session');
define('SESSION_LIFETIME', 7200); // 2 horas

// ── Seguridad ─────────────────────────────────────────────────
define('CSRF_TOKEN_NAME', '_csrf_token');
define('BCRYPT_COST',     12);

// ── Paginación ────────────────────────────────────────────────
define('ITEMS_PER_PAGE', 20);

// ── Zona horaria ──────────────────────────────────────────────
date_default_timezone_set('America/Santiago');

// ── Errores (development) ─────────────────────────────────────
if (APP_ENV === 'development') {
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
} else {
    ini_set('display_errors', 0);
    error_reporting(0);
}

// ── Autoload de clases ────────────────────────────────────────
spl_autoload_register(function ($class) {
    $paths = [
        APP_PATH . '/models/'      . $class . '.php',
        APP_PATH . '/controllers/' . $class . '.php',
        APP_PATH . '/helpers/'     . $class . '.php',
        APP_PATH . '/middleware/'  . $class . '.php',
    ];
    foreach ($paths as $path) {
        if (file_exists($path)) {
            require_once $path;
            return;
        }
    }
});

// ── Helpers globales ──────────────────────────────────────────
require_once APP_PATH . '/helpers/functions.php';
require_once APP_PATH . '/helpers/csrf.php';
require_once APP_PATH . '/helpers/permissions.php';

// ── Iniciar sesión ────────────────────────────────────────────
if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_set_cookie_params([
        'lifetime' => SESSION_LIFETIME,
        'path'     => '/',
        'secure'   => false, // true en HTTPS
        'httponly' => true,
        'samesite' => 'Lax',
    ]);
    session_start();
}

// ── Función global de conexión DB ─────────────────────────────
function db(): Database {
    return Database::getInstance();
}
