<?php /* Vista: Crear Usuario */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-person-plus text-primary me-2"></i>Nuevo Usuario</h4>
    <a href="<?= BASE_URL ?>/usuarios" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<div class="row justify-content-center">
<div class="col-lg-8">
<div class="card border-0 shadow-sm">
<div class="card-body p-4">
<form method="POST" action="<?= BASE_URL ?>/usuarios" enctype="multipart/form-data">
    <?= csrf_field() ?>
    <div class="row g-3">
        <div class="col-12"><h6 class="text-muted fw-semibold border-bottom pb-2">Información Personal</h6></div>

        <div class="col-md-6">
            <label class="form-label fw-medium">Nombre <span class="text-danger">*</span></label>
            <input type="text" name="nombre" class="form-control" value="<?= clean(post('nombre')) ?>" required autofocus>
        </div>
        <div class="col-md-6">
            <label class="form-label fw-medium">Apellido <span class="text-danger">*</span></label>
            <input type="text" name="apellido" class="form-control" value="<?= clean(post('apellido')) ?>" required>
        </div>
        <div class="col-md-7">
            <label class="form-label fw-medium">Email <span class="text-danger">*</span></label>
            <input type="email" name="email" class="form-control" value="<?= clean(post('email')) ?>" required>
        </div>
        <div class="col-md-5">
            <label class="form-label fw-medium">Teléfono</label>
            <input type="text" name="telefono" class="form-control" value="<?= clean(post('telefono')) ?>">
        </div>

        <div class="col-12"><h6 class="text-muted fw-semibold border-bottom pb-2 mt-2">Acceso al Sistema</h6></div>

        <div class="col-md-6">
            <label class="form-label fw-medium">Rol <span class="text-danger">*</span></label>
            <select name="rol_id" class="form-select" required>
                <option value="">Seleccionar rol...</option>
                <?php foreach ($roles as $r): ?>
                <option value="<?= $r['id'] ?>" <?= post('rol_id') == $r['id'] ? 'selected' : '' ?>>
                    <?= clean($r['nombre']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-6">
            <label class="form-label fw-medium">Sucursal</label>
            <select name="sucursal_id" class="form-select">
                <option value="">Todas las sucursales</option>
                <?php foreach ($sucursales as $s): ?>
                <option value="<?= $s['id'] ?>" <?= post('sucursal_id') == $s['id'] ? 'selected' : '' ?>>
                    <?= clean($s['nombre']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-6">
            <label class="form-label fw-medium">Contraseña <span class="text-danger">*</span></label>
            <div class="input-group">
                <input type="password" name="password" id="password" class="form-control" required minlength="8">
                <button type="button" class="btn btn-outline-secondary" onclick="togglePass('password')">
                    <i class="bi bi-eye" id="icon-password"></i>
                </button>
            </div>
            <div class="form-text">Mínimo 8 caracteres.</div>
        </div>
        <div class="col-md-6">
            <label class="form-label fw-medium">Confirmar Contraseña <span class="text-danger">*</span></label>
            <div class="input-group">
                <input type="password" name="password_confirm" id="password_confirm" class="form-control" required>
                <button type="button" class="btn btn-outline-secondary" onclick="togglePass('password_confirm')">
                    <i class="bi bi-eye" id="icon-password_confirm"></i>
                </button>
            </div>
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Estado</label>
            <select name="estado" class="form-select">
                <option value="activo"   <?= post('estado', 'activo') === 'activo'   ? 'selected' : '' ?>>Activo</option>
                <option value="inactivo" <?= post('estado') === 'inactivo' ? 'selected' : '' ?>>Inactivo</option>
            </select>
        </div>

        <div class="col-12 d-flex gap-2 justify-content-end mt-2">
            <a href="<?= BASE_URL ?>/usuarios" class="btn btn-outline-secondary">Cancelar</a>
            <button type="submit" class="btn btn-primary px-4">
                <i class="bi bi-check-lg me-1"></i>Crear Usuario
            </button>
        </div>
    </div>
</form>
</div>
</div>
</div>
</div>

<script>
function togglePass(id) {
    const input = document.getElementById(id);
    const icon  = document.getElementById('icon-' + id);
    if (input.type === 'password') {
        input.type = 'text';
        icon.className = 'bi bi-eye-slash';
    } else {
        input.type = 'password';
        icon.className = 'bi bi-eye';
    }
}
</script>
