<?php /* Vista: Editar Sucursal */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-pencil text-primary me-2"></i>Editar Sucursal</h4>
    <a href="<?= BASE_URL ?>/sucursales" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<div class="row justify-content-center">
<div class="col-lg-7">
<div class="card border-0 shadow-sm">
<div class="card-body p-4">
<form method="POST" action="<?= BASE_URL ?>/sucursales/<?= $sucursal['id'] ?>">
    <?= csrf_field() ?>
    <div class="row g-3">
        <div class="col-md-8">
            <label class="form-label fw-medium">Nombre <span class="text-danger">*</span></label>
            <input type="text" name="nombre" class="form-control" value="<?= clean($sucursal['nombre']) ?>" required>
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Código</label>
            <input type="text" name="codigo" class="form-control" value="<?= clean($sucursal['codigo'] ?? '') ?>">
        </div>
        <div class="col-12">
            <label class="form-label fw-medium">Dirección</label>
            <input type="text" name="direccion" class="form-control" value="<?= clean($sucursal['direccion'] ?? '') ?>">
        </div>
        <div class="col-md-6">
            <label class="form-label fw-medium">Teléfono</label>
            <input type="text" name="telefono" class="form-control" value="<?= clean($sucursal['telefono'] ?? '') ?>">
        </div>
        <div class="col-md-6">
            <label class="form-label fw-medium">Email</label>
            <input type="email" name="email" class="form-control" value="<?= clean($sucursal['email'] ?? '') ?>">
        </div>
        <div class="col-12">
            <label class="form-label fw-medium">Horario de Atención</label>
            <input type="text" name="horario" class="form-control" value="<?= clean($sucursal['horario'] ?? '') ?>">
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Estado</label>
            <select name="estado" class="form-select" <?= $sucursal['es_principal'] ? 'disabled' : '' ?>>
                <option value="activa"   <?= $sucursal['estado'] === 'activa'   ? 'selected' : '' ?>>Activa</option>
                <option value="inactiva" <?= $sucursal['estado'] === 'inactiva' ? 'selected' : '' ?>>Inactiva</option>
            </select>
            <?php if ($sucursal['es_principal']): ?>
            <input type="hidden" name="estado" value="<?= $sucursal['estado'] ?>">
            <div class="form-text text-warning"><i class="bi bi-lock me-1"></i>Sucursal principal siempre activa.</div>
            <?php endif; ?>
        </div>
        <div class="col-12 d-flex gap-2 justify-content-end mt-2">
            <a href="<?= BASE_URL ?>/sucursales" class="btn btn-outline-secondary">Cancelar</a>
            <button type="submit" class="btn btn-primary px-4">
                <i class="bi bi-check-lg me-1"></i>Actualizar Sucursal
            </button>
        </div>
    </div>
</form>
</div>
</div>
</div>
</div>
