<?php /* Vista: Ver Receta */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-eyeglasses text-primary me-2"></i>Receta #<?= $receta['id'] ?></h4>
    <div class="d-flex gap-2">
        <a href="<?= BASE_URL ?>/recetas/<?= $receta['id'] ?>/print" class="btn btn-outline-dark btn-sm" target="_blank">
            <i class="bi bi-printer me-1"></i>Imprimir
        </a>
        <a href="<?= BASE_URL ?>/pacientes/<?= $receta['paciente_id'] ?>" class="btn btn-outline-secondary btn-sm">
            <i class="bi bi-person me-1"></i>Ver Paciente
        </a>
        <a href="<?= BASE_URL ?>/recetas" class="btn btn-outline-secondary btn-sm">
            <i class="bi bi-arrow-left me-1"></i>Volver
        </a>
    </div>
</div>

<div class="row g-3">
    <!-- Info paciente -->
    <div class="col-lg-4">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent"><h6 class="mb-0 fw-semibold">Paciente</h6></div>
            <div class="card-body small">
                <p class="fw-bold mb-1"><?= clean($receta['paciente_nombre']) ?></p>
                <?php if ($receta['paciente_rut']): ?>
                <p class="text-muted mb-1">RUT: <?= clean($receta['paciente_rut']) ?></p>
                <?php endif; ?>
                <?php if ($receta['paciente_telefono']): ?>
                <p class="text-muted mb-1">Tel: <?= clean($receta['paciente_telefono']) ?></p>
                <?php endif; ?>
                <hr class="my-2">
                <p class="mb-1"><strong>Fecha:</strong> <?= formatDate($receta['fecha']) ?></p>
                <?php if ($receta['optometrista_nombre']): ?>
                <p class="mb-1"><strong>Optometrista:</strong> <?= clean($receta['optometrista_nombre']) ?></p>
                <?php endif; ?>
                <?php if ($receta['tipo_lente']): ?>
                <p class="mb-1"><strong>Tipo lente:</strong> <?= ucfirst($receta['tipo_lente']) ?></p>
                <?php endif; ?>
                <?php if ($receta['uso']): ?>
                <p class="mb-1"><strong>Uso:</strong> <?= str_replace('_', '/', ucfirst($receta['uso'])) ?></p>
                <?php endif; ?>
                <?php if ($receta['dp']): ?>
                <p class="mb-0"><strong>D.P.:</strong> <?= $receta['dp'] ?> mm</p>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Tabla de graduación -->
    <div class="col-lg-8">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent"><h6 class="mb-0 fw-semibold">Graduación</h6></div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered text-center mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Ojo</th>
                                <th>Esfera</th>
                                <th>Cilindro</th>
                                <th>Eje</th>
                                <th>Adición</th>
                                <th>AV</th>
                                <th>Prisma</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="fw-bold text-primary">OD</td>
                                <td class="font-monospace"><?= formatReceta($receta['od_esfera']) ?></td>
                                <td class="font-monospace"><?= formatReceta($receta['od_cilindro']) ?></td>
                                <td><?= $receta['od_eje'] ? $receta['od_eje'] . '°' : '-' ?></td>
                                <td class="font-monospace"><?= formatReceta($receta['od_adicion']) ?></td>
                                <td><?= clean($receta['od_av'] ?? '-') ?></td>
                                <td><?= clean($receta['od_prisma'] ?? '-') ?></td>
                            </tr>
                            <tr>
                                <td class="fw-bold text-success">OI</td>
                                <td class="font-monospace"><?= formatReceta($receta['oi_esfera']) ?></td>
                                <td class="font-monospace"><?= formatReceta($receta['oi_cilindro']) ?></td>
                                <td><?= $receta['oi_eje'] ? $receta['oi_eje'] . '°' : '-' ?></td>
                                <td class="font-monospace"><?= formatReceta($receta['oi_adicion']) ?></td>
                                <td><?= clean($receta['oi_av'] ?? '-') ?></td>
                                <td><?= clean($receta['oi_prisma'] ?? '-') ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <?php if ($receta['observaciones']): ?>
                <div class="mt-3 p-3 bg-light rounded small">
                    <strong>Observaciones:</strong> <?= clean($receta['observaciones']) ?>
                </div>
                <?php endif; ?>

                <?php if ($receta['adjunto']): ?>
                <div class="mt-3">
                    <a href="<?= BASE_URL . '/' . $receta['adjunto'] ?>" class="btn btn-sm btn-outline-secondary" target="_blank">
                        <i class="bi bi-paperclip me-1"></i>Ver Adjunto
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
