<?php /* Vista: Mi Perfil */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-person-circle text-primary me-2"></i>Mi Perfil</h4>
</div>

<div class="row g-4">
    <!-- Tarjeta de perfil -->
    <div class="col-lg-4">
        <div class="card border-0 shadow-sm text-center">
            <div class="card-body py-4">
                <?php if (!empty($usuario['avatar'])): ?>
                <img src="<?= BASE_URL ?>/<?= clean($usuario['avatar']) ?>"
                     class="rounded-circle mb-3 border" width="100" height="100"
                     style="object-fit:cover" alt="Avatar">
                <?php else: ?>
                <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center mx-auto mb-3"
                     style="width:100px;height:100px;font-size:2.5rem">
                    <?= strtoupper(substr($usuario['nombre'], 0, 1)) ?>
                </div>
                <?php endif; ?>
                <h5 class="fw-bold mb-0"><?= clean($usuario['nombre'] . ' ' . $usuario['apellido']) ?></h5>
                <p class="text-muted small mb-2"><?= clean($usuario['email']) ?></p>
                <span class="badge bg-primary"><?= clean($usuario['rol_nombre'] ?? 'Sin rol') ?></span>
            </div>
            <div class="card-footer bg-white border-top">
                <div class="row text-center g-0">
                    <div class="col-6 border-end py-2">
                        <div class="text-muted small">Empresa</div>
                        <div class="fw-semibold small"><?= clean($usuario['empresa_nombre'] ?? '-') ?></div>
                    </div>
                    <div class="col-6 py-2">
                        <div class="text-muted small">Sucursal</div>
                        <div class="fw-semibold small"><?= clean($usuario['sucursal_nombre'] ?? '-') ?></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Info adicional -->
        <div class="card border-0 shadow-sm mt-3">
            <div class="card-body">
                <h6 class="fw-bold mb-3">Información de Cuenta</h6>
                <div class="mb-2">
                    <span class="text-muted small d-block">Estado</span>
                    <?= statusBadge($usuario['estado'] ?? 'activo') ?>
                </div>
                <?php if (!empty($usuario['telefono'])): ?>
                <div class="mb-2">
                    <span class="text-muted small d-block">Teléfono</span>
                    <span class="fw-semibold small"><?= clean($usuario['telefono']) ?></span>
                </div>
                <?php endif; ?>
                <div class="mb-0">
                    <span class="text-muted small d-block">Miembro desde</span>
                    <span class="fw-semibold small">
                        <?= !empty($usuario['created_at']) ? date('d/m/Y', strtotime($usuario['created_at'])) : '-' ?>
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Formulario de edición -->
    <div class="col-lg-8">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white fw-semibold border-bottom">
                <i class="bi bi-pencil me-2 text-primary"></i>Editar Información Personal
            </div>
            <div class="card-body p-4">
                <form method="POST" action="<?= BASE_URL ?>/perfil" enctype="multipart/form-data">
                    <?= csrf_field() ?>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label fw-medium">Nombre <span class="text-danger">*</span></label>
                            <input type="text" name="nombre" class="form-control"
                                   value="<?= clean($usuario['nombre']) ?>" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-medium">Apellido <span class="text-danger">*</span></label>
                            <input type="text" name="apellido" class="form-control"
                                   value="<?= clean($usuario['apellido']) ?>" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-medium">Email</label>
                            <input type="email" name="email" class="form-control"
                                   value="<?= clean($usuario['email']) ?>">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-medium">Teléfono</label>
                            <input type="text" name="telefono" class="form-control"
                                   value="<?= clean($usuario['telefono'] ?? '') ?>"
                                   placeholder="+56 9 1234 5678">
                        </div>
                        <div class="col-12">
                            <label class="form-label fw-medium">Foto de Perfil</label>
                            <input type="file" name="avatar" class="form-control"
                                   accept="image/jpeg,image/png,image/gif,image/webp">
                            <div class="form-text">JPG, PNG, GIF o WEBP. Máximo 5MB.</div>
                        </div>
                    </div>

                    <hr class="my-4">

                    <h6 class="fw-bold mb-3"><i class="bi bi-lock me-2"></i>Cambiar Contraseña</h6>
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label fw-medium">Contraseña Actual</label>
                            <input type="password" name="password_actual" class="form-control"
                                   placeholder="Contraseña actual" autocomplete="current-password">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label fw-medium">Nueva Contraseña</label>
                            <input type="password" name="password_nueva" class="form-control"
                                   placeholder="Mínimo 8 caracteres" autocomplete="new-password">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label fw-medium">Confirmar Contraseña</label>
                            <input type="password" name="password_confirmar" class="form-control"
                                   placeholder="Repetir contraseña" autocomplete="new-password">
                        </div>
                        <div class="col-12">
                            <div class="alert alert-info py-2 small mb-0">
                                <i class="bi bi-info-circle me-1"></i>
                                Deja los campos de contraseña vacíos si no deseas cambiarla.
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end mt-4">
                        <button type="submit" class="btn btn-primary px-4">
                            <i class="bi bi-check-lg me-1"></i>Guardar Cambios
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
