<?php /* Vista: Pacientes */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-people text-primary me-2"></i>Pacientes</h4>
    <?php if (can('pacientes.crear')): ?>
    <a href="<?= BASE_URL ?>/pacientes/create" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i>Nuevo Paciente
    </a>
    <?php endif; ?>
</div>

<!-- Búsqueda -->
<div class="card border-0 shadow-sm mb-3">
    <div class="card-body py-2">
        <form method="GET" action="<?= BASE_URL ?>/pacientes" class="d-flex gap-2">
            <input type="text" name="q" class="form-control" placeholder="Buscar por nombre, RUT o email..."
                   value="<?= clean(get('q')) ?>" autofocus>
            <button type="submit" class="btn btn-outline-primary px-3">
                <i class="bi bi-search"></i>
            </button>
            <?php if (get('q')): ?>
            <a href="<?= BASE_URL ?>/pacientes" class="btn btn-outline-secondary">
                <i class="bi bi-x-lg"></i>
            </a>
            <?php endif; ?>
        </form>
    </div>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Paciente</th>
                        <th>RUT / Doc.</th>
                        <th>Teléfono</th>
                        <th>Email</th>
                        <th>Última visita</th>
                        <th class="text-end">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($pacientes as $p): ?>
                <tr>
                    <td>
                        <a href="<?= BASE_URL ?>/pacientes/<?= $p['id'] ?>" class="text-decoration-none fw-semibold">
                            <?= clean($p['nombre'] . ' ' . $p['apellido']) ?>
                        </a>
                        <?php if ($p['fecha_nacimiento']): ?>
                        <div class="text-muted small"><?= calcularEdad($p['fecha_nacimiento']) ?> años</div>
                        <?php endif; ?>
                    </td>
                    <td class="text-muted small"><?= clean($p['rut'] ?? '-') ?></td>
                    <td class="text-muted small"><?= clean($p['telefono'] ?? '-') ?></td>
                    <td class="text-muted small"><?= clean($p['email'] ?? '-') ?></td>
                    <td class="text-muted small"><?= $p['ultima_visita'] ? formatDate($p['ultima_visita']) : 'Sin visitas' ?></td>
                    <td class="text-end">
                        <div class="btn-group btn-group-sm">
                            <a href="<?= BASE_URL ?>/pacientes/<?= $p['id'] ?>" class="btn btn-outline-secondary" title="Ver">
                                <i class="bi bi-eye"></i>
                            </a>
                            <?php if (can('pacientes.editar')): ?>
                            <a href="<?= BASE_URL ?>/pacientes/<?= $p['id'] ?>/edit" class="btn btn-outline-primary" title="Editar">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <?php endif; ?>
                            <?php if (can('recetas.crear')): ?>
                            <a href="<?= BASE_URL ?>/recetas/create?paciente_id=<?= $p['id'] ?>" class="btn btn-outline-success" title="Nueva Receta">
                                <i class="bi bi-eyeglasses"></i>
                            </a>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($pacientes)): ?>
                <tr>
                    <td colspan="6" class="text-center text-muted py-4">
                        <?= get('q') ? 'Sin resultados para "' . clean(get('q')) . '"' : 'No hay pacientes registrados.' ?>
                    </td>
                </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php if (!empty($pagination) && ($pagination['last_page'] ?? 1) > 1): ?>
    <div class="card-footer bg-transparent">
        <?= paginationLinks($pagination, BASE_URL . '/pacientes?q=' . urlencode(get('q'))) ?>
    </div>
    <?php endif; ?>
</div>
