<?php /* Vista: Empresas */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-building text-primary me-2"></i>Empresas</h4>
    <a href="<?= BASE_URL ?>/empresas/create" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i>Nueva Empresa
    </a>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Empresa</th>
                        <th>Plan</th>
                        <th>Email</th>
                        <th>País</th>
                        <th>Estado</th>
                        <th>Registro</th>
                        <th class="text-end">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($empresas as $e): ?>
                <tr>
                    <td>
                        <a href="<?= BASE_URL ?>/empresas/<?= $e['id'] ?>" class="text-decoration-none fw-semibold">
                            <?php if ($e['logo']): ?>
                            <img src="<?= BASE_URL . '/' . $e['logo'] ?>" height="24" class="me-2 rounded" alt="">
                            <?php endif; ?>
                            <?= clean($e['nombre']) ?>
                        </a>
                        <?php if ($e['rut']): ?>
                        <div class="text-muted small"><?= clean($e['rut']) ?></div>
                        <?php endif; ?>
                    </td>
                    <td><span class="badge bg-secondary"><?= clean($e['plan_nombre'] ?? '-') ?></span></td>
                    <td class="text-muted small"><?= clean($e['email'] ?? '-') ?></td>
                    <td class="text-muted small"><?= clean($e['pais'] ?? '-') ?></td>
                    <td><?= statusBadge($e['estado']) ?></td>
                    <td class="text-muted small"><?= formatDate($e['created_at']) ?></td>
                    <td class="text-end">
                        <div class="btn-group btn-group-sm">
                            <a href="<?= BASE_URL ?>/empresas/<?= $e['id'] ?>" class="btn btn-outline-secondary" title="Ver">
                                <i class="bi bi-eye"></i>
                            </a>
                            <a href="<?= BASE_URL ?>/empresas/<?= $e['id'] ?>/edit" class="btn btn-outline-primary" title="Editar">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <form method="POST" action="<?= BASE_URL ?>/empresas/<?= $e['id'] ?>/delete"
                                  data-confirm="¿Eliminar empresa <?= clean($e['nombre']) ?>? Esta acción es irreversible.">
                                <?= csrf_field() ?>
                                <button type="submit" class="btn btn-outline-danger" title="Eliminar">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($empresas)): ?>
                <tr>
                    <td colspan="7" class="text-center text-muted py-4">
                        <i class="bi bi-building fs-2 d-block mb-2 opacity-25"></i>
                        No hay empresas registradas.
                    </td>
                </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
