<?php /* Vista: Editar Empresa */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-pencil text-primary me-2"></i>Editar Empresa</h4>
    <div class="d-flex gap-2">
        <a href="<?= BASE_URL ?>/empresas/<?= $empresa['id'] ?>" class="btn btn-outline-secondary btn-sm">
            <i class="bi bi-eye me-1"></i>Ver
        </a>
        <a href="<?= BASE_URL ?>/empresas" class="btn btn-outline-secondary btn-sm">
            <i class="bi bi-arrow-left me-1"></i>Volver
        </a>
    </div>
</div>

<div class="row justify-content-center">
<div class="col-lg-9">
<div class="card border-0 shadow-sm">
<div class="card-body p-4">
<form method="POST" action="<?= BASE_URL ?>/empresas/<?= $empresa['id'] ?>" enctype="multipart/form-data">
    <?= csrf_field() ?>

    <div class="row g-3">
        <div class="col-12"><h6 class="text-muted fw-semibold border-bottom pb-2">Datos de la Empresa</h6></div>

        <div class="col-md-8">
            <label class="form-label fw-medium">Nombre <span class="text-danger">*</span></label>
            <input type="text" name="nombre" class="form-control" value="<?= clean($empresa['nombre']) ?>" required>
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Plan <span class="text-danger">*</span></label>
            <select name="plan_id" class="form-select" required>
                <?php foreach ($planes as $p): ?>
                <option value="<?= $p['id'] ?>" <?= $empresa['plan_id'] == $p['id'] ? 'selected' : '' ?>>
                    <?= clean($p['nombre']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-md-6">
            <label class="form-label fw-medium">Razón Social</label>
            <input type="text" name="razon_social" class="form-control" value="<?= clean($empresa['razon_social'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-medium">RUT / NIT</label>
            <input type="text" name="rut" class="form-control" value="<?= clean($empresa['rut'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-medium">Moneda</label>
            <select name="moneda" class="form-select">
                <?php foreach (['CLP','USD','PEN','COP','MXN','ARS'] as $m): ?>
                <option value="<?= $m ?>" <?= $empresa['moneda'] === $m ? 'selected' : '' ?>><?= $m ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-12"><h6 class="text-muted fw-semibold border-bottom pb-2 mt-2">Contacto</h6></div>

        <div class="col-md-6">
            <label class="form-label fw-medium">Email</label>
            <input type="email" name="email" class="form-control" value="<?= clean($empresa['email'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-medium">Teléfono</label>
            <input type="text" name="telefono" class="form-control" value="<?= clean($empresa['telefono'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-medium">País</label>
            <input type="text" name="pais" class="form-control" value="<?= clean($empresa['pais'] ?? 'Chile') ?>">
        </div>

        <div class="col-md-8">
            <label class="form-label fw-medium">Dirección</label>
            <input type="text" name="direccion" class="form-control" value="<?= clean($empresa['direccion'] ?? '') ?>">
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Ciudad</label>
            <input type="text" name="ciudad" class="form-control" value="<?= clean($empresa['ciudad'] ?? '') ?>">
        </div>

        <div class="col-12"><h6 class="text-muted fw-semibold border-bottom pb-2 mt-2">Personalización</h6></div>

        <div class="col-md-3">
            <label class="form-label fw-medium">Color Primario</label>
            <input type="color" name="color_primario" class="form-control form-control-color w-100"
                   value="<?= clean($empresa['color_primario'] ?? '#0d6efd') ?>">
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Logo actual</label>
            <?php if ($empresa['logo']): ?>
            <div class="mb-1">
                <img src="<?= BASE_URL . '/' . $empresa['logo'] ?>" height="40" class="rounded border" alt="Logo">
            </div>
            <?php endif; ?>
            <input type="file" name="logo" class="form-control form-control-sm" accept="image/*">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-medium">Estado</label>
            <select name="estado" class="form-select">
                <?php foreach (['activa','suspendida','expirada','prueba'] as $est): ?>
                <option value="<?= $est ?>" <?= $empresa['estado'] === $est ? 'selected' : '' ?>>
                    <?= ucfirst($est) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-12 d-flex gap-2 justify-content-end mt-2">
            <a href="<?= BASE_URL ?>/empresas" class="btn btn-outline-secondary">Cancelar</a>
            <button type="submit" class="btn btn-primary px-4">
                <i class="bi bi-check-lg me-1"></i>Actualizar Empresa
            </button>
        </div>
    </div>
</form>
</div>
</div>
</div>
</div>
