<?php /* Vista: Dashboard */ ?>

<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4 class="mb-0 fw-bold">
            <i class="bi bi-speedometer2 text-primary me-2"></i>Dashboard
        </h4>
        <small class="text-muted"><?= date('l, d \d\e F \d\e Y') ?></small>
    </div>
</div>

<?php if (isSuperAdmin()): ?>
<!-- ── Vista SuperAdmin ──────────────────────────────────── -->

<div class="row g-3 mb-4">
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body d-flex align-items-center gap-3">
                <div class="rounded-3 bg-primary bg-opacity-10 p-3">
                    <i class="bi bi-building text-primary fs-4"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold"><?= $stats['empresas'] ?></div>
                    <div class="text-muted small">Empresas</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body d-flex align-items-center gap-3">
                <div class="rounded-3 bg-success bg-opacity-10 p-3">
                    <i class="bi bi-key text-success fs-4"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold"><?= $stats['licencias'] ?></div>
                    <div class="text-muted small">Licencias Activas</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body d-flex align-items-center gap-3">
                <div class="rounded-3 bg-info bg-opacity-10 p-3">
                    <i class="bi bi-layers text-info fs-4"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold"><?= $stats['planes'] ?></div>
                    <div class="text-muted small">Planes</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body d-flex align-items-center gap-3">
                <div class="rounded-3 bg-warning bg-opacity-10 p-3">
                    <i class="bi bi-people text-warning fs-4"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold"><?= $stats['usuarios'] ?></div>
                    <div class="text-muted small">Usuarios Totales</div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row g-3">
    <!-- Empresas recientes -->
    <div class="col-lg-7">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-semibold"><i class="bi bi-building me-2"></i>Empresas Recientes</h6>
                <a href="<?= BASE_URL ?>/empresas" class="btn btn-sm btn-outline-primary">Ver todas</a>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Empresa</th>
                                <th>Plan</th>
                                <th>Estado</th>
                                <th>Fecha</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($empresas_recientes as $e): ?>
                            <tr>
                                <td>
                                    <a href="<?= BASE_URL ?>/empresas/<?= $e['id'] ?>" class="text-decoration-none fw-medium">
                                        <?= clean($e['nombre']) ?>
                                    </a>
                                </td>
                                <td><span class="badge bg-secondary"><?= clean($e['plan_nombre']) ?></span></td>
                                <td><?= statusBadge($e['estado']) ?></td>
                                <td class="text-muted small"><?= formatDate($e['created_at']) ?></td>
                            </tr>
                        <?php endforeach; ?>
                        <?php if (empty($empresas_recientes)): ?>
                            <tr><td colspan="4" class="text-center text-muted py-3">Sin empresas registradas</td></tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Licencias por vencer -->
    <div class="col-lg-5">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent border-0">
                <h6 class="mb-0 fw-semibold"><i class="bi bi-exclamation-triangle text-warning me-2"></i>Licencias por Vencer (7 días)</h6>
            </div>
            <div class="card-body p-0">
                <?php if (empty($licencias_por_vencer)): ?>
                    <div class="text-center text-muted py-4">
                        <i class="bi bi-check-circle text-success fs-3 d-block mb-2"></i>
                        Sin licencias próximas a vencer
                    </div>
                <?php else: ?>
                <ul class="list-group list-group-flush">
                    <?php foreach ($licencias_por_vencer as $l): ?>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <div>
                            <div class="fw-medium small"><?= clean($l['empresa_nombre']) ?></div>
                            <div class="text-muted" style="font-size:11px"><?= formatDate($l['fecha_fin']) ?></div>
                        </div>
                        <span class="badge bg-<?= $l['dias_restantes'] <= 3 ? 'danger' : 'warning' ?>">
                            <?= $l['dias_restantes'] ?> días
                        </span>
                    </li>
                    <?php endforeach; ?>
                </ul>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php else: ?>
<!-- ── Vista Empresa ─────────────────────────────────────── -->

<div class="row g-3 mb-4">
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body d-flex align-items-center gap-3">
                <div class="rounded-3 bg-primary bg-opacity-10 p-3">
                    <i class="bi bi-people text-primary fs-4"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold"><?= $stats['pacientes'] ?></div>
                    <div class="text-muted small">Pacientes</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body d-flex align-items-center gap-3">
                <div class="rounded-3 bg-success bg-opacity-10 p-3">
                    <i class="bi bi-receipt text-success fs-4"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold"><?= $stats['ventas_hoy']['total'] ?? 0 ?></div>
                    <div class="text-muted small">Ventas Hoy</div>
                    <div class="text-success small fw-medium"><?= formatMoney($stats['ventas_hoy']['monto'] ?? 0, Auth::moneda()) ?></div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body d-flex align-items-center gap-3">
                <div class="rounded-3 bg-info bg-opacity-10 p-3">
                    <i class="bi bi-box-seam text-info fs-4"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold"><?= $stats['productos'] ?></div>
                    <div class="text-muted small">Productos</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body d-flex align-items-center gap-3">
                <?php $caja = $stats['caja']; ?>
                <div class="rounded-3 bg-<?= $caja ? 'success' : 'secondary' ?> bg-opacity-10 p-3">
                    <i class="bi bi-cash-register text-<?= $caja ? 'success' : 'secondary' ?> fs-4"></i>
                </div>
                <div>
                    <div class="fw-bold"><?= $caja ? 'Abierta' : 'Cerrada' ?></div>
                    <div class="text-muted small">Caja</div>
                    <?php if ($caja): ?>
                    <div class="text-muted" style="font-size:11px">desde <?= formatDateTime($caja['fecha_apertura'], 'H:i') ?></div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row g-3">
    <!-- Últimas ventas -->
    <div class="col-lg-7">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-semibold"><i class="bi bi-receipt me-2"></i>Últimas Ventas</h6>
                <?php if (can('ventas.ver')): ?>
                <a href="<?= BASE_URL ?>/ventas" class="btn btn-sm btn-outline-primary">Ver todas</a>
                <?php endif; ?>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>Paciente</th>
                                <th>Total</th>
                                <th>Estado</th>
                                <th>Fecha</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($ultimas_ventas as $v): ?>
                            <tr>
                                <td>
                                    <a href="<?= BASE_URL ?>/ventas/<?= $v['id'] ?>" class="text-decoration-none fw-medium">
                                        <?= clean($v['correlativo']) ?>
                                    </a>
                                </td>
                                <td class="text-muted small"><?= clean($v['paciente_nombre'] ?? 'Sin paciente') ?></td>
                                <td class="fw-medium"><?= formatMoney($v['total'], Auth::moneda()) ?></td>
                                <td><?= statusBadge($v['estado']) ?></td>
                                <td class="text-muted small"><?= formatDateTime($v['created_at'], 'H:i') ?></td>
                            </tr>
                        <?php endforeach; ?>
                        <?php if (empty($ultimas_ventas)): ?>
                            <tr><td colspan="5" class="text-center text-muted py-3">Sin ventas registradas hoy</td></tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Stock bajo -->
    <div class="col-lg-5">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-semibold"><i class="bi bi-exclamation-triangle text-warning me-2"></i>Stock Bajo</h6>
                <?php if (can('stock.ver')): ?>
                <a href="<?= BASE_URL ?>/stock" class="btn btn-sm btn-outline-warning">Ver stock</a>
                <?php endif; ?>
            </div>
            <div class="card-body p-0">
                <?php if (empty($stock_bajo)): ?>
                    <div class="text-center text-muted py-4">
                        <i class="bi bi-check-circle text-success fs-3 d-block mb-2"></i>
                        Stock en niveles normales
                    </div>
                <?php else: ?>
                <ul class="list-group list-group-flush">
                    <?php foreach ($stock_bajo as $s): ?>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <div>
                            <div class="fw-medium small"><?= clean($s['nombre']) ?></div>
                            <div class="text-muted" style="font-size:11px"><?= clean($s['sucursal']) ?></div>
                        </div>
                        <span class="badge bg-<?= $s['cantidad'] <= 0 ? 'danger' : 'warning' ?>">
                            <?= $s['cantidad'] ?> / <?= $s['stock_minimo'] ?>
                        </span>
                    </li>
                    <?php endforeach; ?>
                </ul>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php endif; ?>
