<?php /* Vista: Detalle de Caja */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4 class="mb-0 fw-bold"><i class="bi bi-cash-register text-primary me-2"></i>Detalle de Caja</h4>
        <small class="text-muted">Apertura: <?= formatDateTime($caja['fecha_apertura']) ?></small>
    </div>
    <div class="d-flex gap-2">
        <a href="<?= BASE_URL ?>/caja/<?= $caja['id'] ?>/print" class="btn btn-outline-dark btn-sm" target="_blank">
            <i class="bi bi-printer me-1"></i>Imprimir
        </a>
        <a href="<?= BASE_URL ?>/caja" class="btn btn-outline-secondary btn-sm">
            <i class="bi bi-arrow-left me-1"></i>Volver
        </a>
    </div>
</div>

<!-- Estado y resumen -->
<div class="row g-3 mb-4">
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-4 fw-bold text-success"><?= formatMoney($caja['monto_apertura'], Auth::moneda()) ?></div>
            <div class="text-muted small">Saldo Inicial</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-4 fw-bold text-primary"><?= formatMoney($resumen['total_ventas'] ?? 0, Auth::moneda()) ?></div>
            <div class="text-muted small">Total Ventas (<?= $resumen['cantidad_ventas'] ?? 0 ?>)</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-4 fw-bold text-warning"><?= formatMoney($resumen['total_egresos'] ?? 0, Auth::moneda()) ?></div>
            <div class="text-muted small">Egresos</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <?php $saldoFinal = $caja['monto_cierre_real'] ?? ($caja['monto_apertura'] + ($resumen['total_ventas'] ?? 0) - ($resumen['total_egresos'] ?? 0)); ?>
            <div class="fs-4 fw-bold text-info"><?= formatMoney($saldoFinal, Auth::moneda()) ?></div>
            <div class="text-muted small">Saldo <?= $caja['estado'] === 'cerrada' ? 'Final' : 'Estimado' ?></div>
        </div>
    </div>
</div>

<div class="row g-3">
    <!-- Info de la caja -->
    <div class="col-lg-4">
        <div class="card border-0 shadow-sm mb-3">
            <div class="card-header bg-transparent"><h6 class="mb-0 fw-semibold">Información</h6></div>
            <div class="card-body small">
                <dl class="row mb-0">
                    <dt class="col-5 text-muted">Estado</dt>
                    <dd class="col-7"><?= statusBadge($caja['estado']) ?></dd>
                    <dt class="col-5 text-muted">Sucursal</dt>
                    <dd class="col-7"><?= clean($caja['sucursal_nombre']) ?></dd>
                    <dt class="col-5 text-muted">Apertura</dt>
                    <dd class="col-7"><?= formatDateTime($caja['fecha_apertura']) ?></dd>
                    <?php if ($caja['fecha_cierre']): ?>
                    <dt class="col-5 text-muted">Cierre</dt>
                    <dd class="col-7"><?= formatDateTime($caja['fecha_cierre']) ?></dd>
                    <?php endif; ?>
                    <dt class="col-5 text-muted">Abrió</dt>
                    <dd class="col-7"><?= clean($caja['cajero_nombre'] ?? '-') ?></dd>
                    <?php if ($caja['diferencia'] !== null): ?>
                    <dt class="col-5 text-muted">Diferencia</dt>
                    <dd class="col-7 <?= $caja['diferencia'] >= 0 ? 'text-success' : 'text-danger' ?>">
                        <?= formatMoney($caja['diferencia'], Auth::moneda()) ?>
                    </dd>
                    <?php endif; ?>
                </dl>
                <?php if ($caja['observaciones']): ?>
                <hr>
                <div class="text-muted small"><strong>Notas:</strong> <?= clean($caja['observaciones']) ?></div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Ventas por método -->
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent"><h6 class="mb-0 fw-semibold">Por Método de Pago</h6></div>
            <div class="card-body p-0">
                <table class="table table-sm mb-0">
                    <thead class="table-light">
                        <tr><th>Método</th><th class="text-end">Total</th></tr>
                    </thead>
                    <tbody>
                    <?php foreach ($porMetodo as $m): ?>
                    <tr>
                        <td class="small"><?= clean($m['forma_pago'] ?? '-') ?></td>
                        <td class="text-end small fw-medium"><?= formatMoney($m['ingresos'] ?? 0, Auth::moneda()) ?></td>
                    </tr>
                    <?php endforeach; ?>
                    <?php if (empty($porMetodo)): ?>
                    <tr><td colspan="2" class="text-center text-muted py-2 small">Sin ventas.</td></tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Movimientos y ventas -->
    <div class="col-lg-8">
        <!-- Movimientos de caja -->
        <div class="card border-0 shadow-sm mb-3">
            <div class="card-header bg-transparent"><h6 class="mb-0 fw-semibold">Movimientos de Caja</h6></div>
            <div class="card-body p-0">
                <table class="table table-sm table-hover mb-0">
                    <thead class="table-light">
                        <tr><th>Tipo</th><th>Concepto</th><th class="text-end">Monto</th><th>Hora</th></tr>
                    </thead>
                    <tbody>
                    <?php foreach ($movimientos as $m): ?>
                    <tr>
                        <td><span class="badge bg-<?= $m['tipo'] === 'ingreso' ? 'success' : 'danger' ?>"><?= $m['tipo'] ?></span></td>
                        <td class="small"><?= clean($m['concepto']) ?></td>
                        <td class="text-end small fw-medium <?= $m['tipo'] === 'ingreso' ? 'text-success' : 'text-danger' ?>">
                            <?= $m['tipo'] === 'egreso' ? '-' : '' ?><?= formatMoney($m['monto'], Auth::moneda()) ?>
                        </td>
                        <td class="small text-muted"><?= formatDateTime($m['fecha'], 'H:i') ?></td>
                    </tr>
                    <?php endforeach; ?>
                    <?php if (empty($movimientos)): ?>
                    <tr><td colspan="4" class="text-center text-muted py-2 small">Sin movimientos.</td></tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Ventas del período -->
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent"><h6 class="mb-0 fw-semibold">Ventas del Período</h6></div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-sm table-hover mb-0">
                        <thead class="table-light">
                            <tr><th>#</th><th>Paciente</th><th class="text-end">Total</th><th>Estado</th><th>Hora</th></tr>
                        </thead>
                        <tbody>
                        <?php foreach ($ventas as $v): ?>
                        <tr>
                            <td class="small">
                                <a href="<?= BASE_URL ?>/ventas/<?= $v['id'] ?>" class="text-decoration-none font-monospace">
                                    <?= clean($v['correlativo']) ?>
                                </a>
                            </td>
                            <td class="small"><?= clean($v['paciente_nombre'] ?? 'Sin paciente') ?></td>
                            <td class="text-end small fw-medium"><?= formatMoney($v['total'], Auth::moneda()) ?></td>
                            <td><?= statusBadge($v['estado']) ?></td>
                            <td class="small text-muted"><?= formatDateTime($v['fecha'], 'H:i') ?></td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if (empty($ventas)): ?>
                        <tr><td colspan="5" class="text-center text-muted py-2 small">Sin ventas.</td></tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
