<?php /* Vista: Recuperar Contraseña */ ?>

<div class="card shadow-sm border-0">
    <div class="card-body p-4">
        <div class="text-center mb-4">
            <div class="rounded-circle bg-primary bg-opacity-10 d-inline-flex align-items-center justify-content-center mb-3"
                 style="width:56px;height:56px">
                <i class="bi bi-key fs-3 text-primary"></i>
            </div>
            <h5 class="card-title fw-semibold mb-1">Recuperar Contraseña</h5>
            <p class="text-muted small mb-0">Ingresa tu email y te mostraremos el enlace de restablecimiento.</p>
        </div>

        <form method="POST" action="<?= BASE_URL ?>/forgot-password" novalidate>
            <?= csrf_field() ?>

            <div class="mb-4">
                <label for="email" class="form-label fw-medium">
                    <i class="bi bi-envelope me-1"></i>Email registrado
                </label>
                <input type="email"
                       class="form-control form-control-lg"
                       id="email"
                       name="email"
                       value="<?= clean(post('email')) ?>"
                       placeholder="usuario@empresa.com"
                       required
                       autofocus>
            </div>

            <div class="d-grid mb-3">
                <button type="submit" class="btn btn-primary btn-lg fw-semibold">
                    <i class="bi bi-send me-2"></i>Generar Enlace
                </button>
            </div>

            <div class="text-center">
                <a href="<?= BASE_URL ?>/login" class="text-muted small text-decoration-none">
                    <i class="bi bi-arrow-left me-1"></i>Volver al inicio de sesión
                </a>
            </div>
        </form>

        <?php if (!empty($resetLink)): ?>
        <!-- ── Enlace de restablecimiento (modo desarrollo) ── -->
        <div class="alert alert-info mt-4 mb-0">
            <h6 class="alert-heading fw-bold">
                <i class="bi bi-info-circle me-1"></i>Enlace de restablecimiento generado
            </h6>
            <p class="small mb-2">
                En producción este enlace se enviaría por email. Por ahora, cópialo directamente:
            </p>
            <div class="input-group input-group-sm">
                <input type="text" class="form-control font-monospace small"
                       id="resetLinkInput"
                       value="<?= clean($resetLink) ?>"
                       readonly>
                <button class="btn btn-outline-secondary" type="button"
                        onclick="navigator.clipboard.writeText(document.getElementById('resetLinkInput').value);this.innerHTML='<i class=\'bi bi-check\'></i> Copiado'">
                    <i class="bi bi-clipboard"></i> Copiar
                </button>
            </div>
            <div class="mt-2">
                <a href="<?= clean($resetLink) ?>" class="btn btn-sm btn-primary">
                    <i class="bi bi-arrow-right-circle me-1"></i>Ir al formulario de restablecimiento
                </a>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
