<?php
class Usuario extends BaseModel
{
    protected string $table = 'usuarios';

    public function getAll(int $page = 1, string $search = ''): array
    {
        if (Auth::isSuperAdmin()) {
            $params = [];
            $where  = '1=1';
        } else {
            $params = [$this->empresaScope()];
            $where  = 'u.empresa_id = ?';
        }
        if ($search) {
            $s = "%$search%";
            $where .= " AND (CONCAT(u.nombre,' ',u.apellido) LIKE ? OR u.email LIKE ?)";
            $params[] = $s; $params[] = $s;
        }
        $sql = "SELECT u.*, r.nombre as rol_nombre, r.slug as rol_slug,
                       s.nombre as sucursal_nombre
                FROM usuarios u
                LEFT JOIN roles r ON u.rol_id = r.id
                LEFT JOIN sucursales s ON u.sucursal_id = s.id
                WHERE $where ORDER BY u.nombre, u.apellido";
        return $this->db->paginate($sql, $params, $page);
    }

    public function getById(int $id): array|false
    {
        return $this->db->fetchOne(
            "SELECT u.*, r.nombre as rol_nombre, s.nombre as sucursal_nombre
             FROM usuarios u
             LEFT JOIN roles r ON u.rol_id = r.id
             LEFT JOIN sucursales s ON u.sucursal_id = s.id
             WHERE u.id = ? AND (u.empresa_id = ? OR u.es_superadmin = 1)",
            [$id, $this->empresaScope()]
        );
    }

    public function crear(array $data): int
    {
        $data['password']   = password_hash($data['password'], PASSWORD_BCRYPT, ['cost' => BCRYPT_COST]);
        $data['empresa_id'] = $this->empresaScope();
        unset($data['password_confirm']);
        return $this->db->insert('usuarios', $data);
    }

    public function actualizar(int $id, array $data): int
    {
        if (!empty($data['password'])) {
            $data['password'] = password_hash($data['password'], PASSWORD_BCRYPT, ['cost' => BCRYPT_COST]);
        } else {
            unset($data['password']);
        }
        unset($data['password_confirm']);
        return $this->db->update('usuarios', $data, ['id' => $id, 'empresa_id' => $this->empresaScope()]);
    }

    public function getRoles(): array
    {
        $empresaId = $this->empresaScope();
        return $this->db->fetchAll(
            "SELECT * FROM roles WHERE (empresa_id = ? OR empresa_id IS NULL) AND estado = 'activo' AND slug != 'superadmin' ORDER BY nombre",
            [$empresaId]
        );
    }
}
