<?php
/**
 * OptiCore SaaS - Helper de Permisos
 * Funciones de acceso rápido para verificar permisos en vistas y controladores
 */

// ── Verificar permiso (alias corto) ───────────────────────────
function can(string $permiso): bool
{
    return Auth::hasPermission($permiso);
}

// ── Verificar cualquiera de los permisos ──────────────────────
function canAny(array $permisos): bool
{
    return Auth::hasAnyPermission($permisos);
}

// ── Verificar todos los permisos ──────────────────────────────
function canAll(array $permisos): bool
{
    return Auth::hasAllPermissions($permisos);
}

// ── Requerir permiso o abortar ────────────────────────────────
function requireCan(string $permiso): void
{
    Auth::requirePermission($permiso);
}

// ── Verificar si es superadmin ────────────────────────────────
function isSuperAdmin(): bool
{
    return Auth::isSuperAdmin();
}

// ── Verificar si es admin de empresa ─────────────────────────
function isAdmin(): bool
{
    return Auth::rolSlug() === 'admin' || Auth::isSuperAdmin();
}

// ── Renderizar botón solo si tiene permiso ────────────────────
function btnIf(string $permiso, string $html): string
{
    return can($permiso) ? $html : '';
}

// ── Mapa completo de permisos del sistema ─────────────────────
function getPermisosDelSistema(): array
{
    return [
        'dashboard' => [
            'dashboard.ver' => 'Ver Dashboard',
        ],
        'pacientes' => [
            'pacientes.ver'      => 'Ver Pacientes',
            'pacientes.crear'    => 'Crear Pacientes',
            'pacientes.editar'   => 'Editar Pacientes',
            'pacientes.eliminar' => 'Eliminar Pacientes',
        ],
        'recetas' => [
            'recetas.ver'      => 'Ver Recetas',
            'recetas.crear'    => 'Crear Recetas',
            'recetas.eliminar' => 'Eliminar Recetas',
            'recetas.imprimir' => 'Imprimir Recetas',
        ],
        'productos' => [
            'productos.ver'      => 'Ver Productos',
            'productos.crear'    => 'Crear Productos',
            'productos.editar'   => 'Editar Productos',
            'productos.eliminar' => 'Eliminar Productos',
        ],
        'stock' => [
            'stock.ver'     => 'Ver Stock',
            'stock.ajustar' => 'Ajustar Stock',
            'stock.kardex'  => 'Ver Kardex',
        ],
        'ventas' => [
            'ventas.ver'      => 'Ver Ventas',
            'ventas.crear'    => 'Crear Ventas',
            'ventas.anular'   => 'Anular Ventas',
            'ventas.imprimir' => 'Imprimir Ventas',
        ],
        'caja' => [
            'caja.ver'        => 'Ver Caja',
            'caja.abrir'      => 'Abrir Caja',
            'caja.cerrar'     => 'Cerrar Caja',
            'caja.movimiento' => 'Registrar Movimientos',
        ],
        'reportes' => [
            'reportes.ver'    => 'Ver Reportes',
            'reportes.ventas' => 'Reporte de Ventas',
            'reportes.stock'  => 'Reporte de Stock',
            'reportes.caja'   => 'Reporte de Caja',
        ],
        'usuarios' => [
            'usuarios.ver'      => 'Ver Usuarios',
            'usuarios.crear'    => 'Crear Usuarios',
            'usuarios.editar'   => 'Editar Usuarios',
            'usuarios.eliminar' => 'Eliminar Usuarios',
        ],
        'roles' => [
            'roles.ver'      => 'Ver Roles',
            'roles.crear'    => 'Crear Roles',
            'roles.editar'   => 'Editar Roles',
            'roles.eliminar' => 'Eliminar Roles',
        ],
        'sucursales' => [
            'sucursales.ver'      => 'Ver Sucursales',
            'sucursales.crear'    => 'Crear Sucursales',
            'sucursales.editar'   => 'Editar Sucursales',
            'sucursales.eliminar' => 'Eliminar Sucursales',
        ],
        'empresa' => [
            'empresa.ver'    => 'Ver Configuración Empresa',
            'empresa.editar' => 'Editar Configuración Empresa',
        ],
        'categorias' => [
            'categorias.ver'      => 'Ver Categorías',
            'categorias.crear'    => 'Crear Categorías',
            'categorias.editar'   => 'Editar Categorías',
            'categorias.eliminar' => 'Eliminar Categorías',
        ],
        'marcas' => [
            'marcas.ver'      => 'Ver Marcas',
            'marcas.crear'    => 'Crear Marcas',
            'marcas.editar'   => 'Editar Marcas',
            'marcas.eliminar' => 'Eliminar Marcas',
        ],
        'proveedores' => [
            'proveedores.ver'      => 'Ver Proveedores',
            'proveedores.crear'    => 'Crear Proveedores',
            'proveedores.editar'   => 'Editar Proveedores',
            'proveedores.eliminar' => 'Eliminar Proveedores',
        ],
        'formas_pago' => [
            'formas_pago.ver'      => 'Ver Formas de Pago',
            'formas_pago.crear'    => 'Crear Formas de Pago',
            'formas_pago.editar'   => 'Editar Formas de Pago',
            'formas_pago.eliminar' => 'Eliminar Formas de Pago',
        ],
        'laboratorio' => [
            'laboratorio.ver'    => 'Ver Órdenes de Laboratorio',
            'laboratorio.crear'  => 'Crear Órdenes de Laboratorio',
            'laboratorio.editar' => 'Editar Órdenes de Laboratorio',
        ],
        'agenda' => [
            'agenda.ver'      => 'Ver Agenda',
            'agenda.crear'    => 'Crear Citas',
            'agenda.editar'   => 'Editar Citas',
            'agenda.eliminar' => 'Eliminar Citas',
        ],
        'audit_logs' => [
            'audit_logs.ver' => 'Ver Audit Logs',
        ],
        'perfil' => [
            'perfil.ver'    => 'Ver Perfil Propio',
            'perfil.editar' => 'Editar Perfil Propio',
        ],
    ];
}
